import de.bebagoe.figuren.*;

void main() {
    // Bei den in Java 21 für switch-Anweisungen und switch-Ausdrücke eingeführten Musterabgleichen
    // berücksichtigt der Compiler versiegelte Klassen, sodass ggf. kein default-Fall erforderlich ist,
    // um die Exhaustivität herzustellen.
    var fa = new Figur[3];
    fa[0] = new Kreis(50.0, 50.0, 50.0);
    fa[1] = new Rechteck(50.0, 10.0, 100.0, 100.0);
    fa[2] = new Quadrat(150.0, 110.0, 30.0);
    double x = 100.0, y = 100.0;
    for (var f : fa)
        switch (f) {
            case Kreis fig -> IO.println("Radius: " + fig.getRadius());
            case Rechteck fig -> IO.println("Breite: " + fig.getBreite());
            case Quadrat fig -> IO.println("Seitenlänge: " + fig.getSeite());
        }

    // Verbesserte Fehlererkennung durch den Compiler aufgrund der Versiegelung
    var q = new Quadrat(150.0, 110.0, 30.0);
//	Comparable cq = (Comparable) q; // Laufzeitfehler
    var r = new Rechteck(50.0, 10.0, 100.0, 100.0);
//	Comparable cr = (Comparable) r; // Compiler entdeckt den Fehler

    // Rechtecke mit einem Seitenverhältnis nach dem goldenen Schnitt
    var rgs = new RechteckGS(30.0, 30.0, 100, Orientierung.STEHEND);
    IO.println("Höhe des GS-Rechtecks:                  " + rgs.getHoehe());
    var rgsDef = new RechteckGS();
    IO.println("Höhe des voreingestellten GS-Rechtecks: " + rgsDef.getHoehe());
}